#ifndef DRAWAREA_H
#define DRAWAREA_H

#include <QWidget>
#include <QPainter>
#include <QTimeZone>
#include "R2Graph.h"

// Time zone id's (must be zero-based!)
constexpr int TZ_LOCAL = 0; // Must be zero
constexpr int TZ_UTC = 1;
constexpr int TZ_MOSCOW = 2;
constexpr int TZ_SHANGHAI = 3;
constexpr int TZ_NEWYORK = 4;

constexpr int NUM_TIME_ZONES = 5;

class DrawArea : public QWidget
{
    Q_OBJECT
public:
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double radiusX;
    double radiusY;
    double longStroke;
    double shortStroke;
    double textShift;
    double handHour;
    double handMin;
    double handSec;
    QColor handHourColor;
    QColor handMinColor;
    QColor handSecColor;
    bool initialUpdate;
    int timeZoneID;
    QTimeZone timeZones[NUM_TIME_ZONES];

    QPointF mapToPixels(const R2Point& t) const {
        int w = width();
        int h = height();
        double x = w * (t.x - xmin)/(xmax - xmin);
        double y = h * (ymax - t.y)/(ymax - ymin);
        return QPointF(x, y);
    }

    R2Point mapFromPixels(const QPointF& p) const {
        int w = width();
        int h = height();
        if (w == 0 || h == 0)
            return R2Point(0., 0.);
        double x = xmin + p.x()/double(w)*(xmax - xmin);
        double y = ymax - p.y()/double(h)*(ymax - ymin);
        return R2Point(x, y);
    }

    explicit DrawArea(QWidget *parent = nullptr);

    void paintEvent(QPaintEvent *);
    void drawFace(QPainter* painter);
    void drawHands(QPainter* painter);
    void drawHand(
        QPainter* painter,
        double angle,
        double handLength,
        QColor handColor
    );
    void animate();
    void redraw();
    void setTimeZone(int id);

signals:

};

#endif // DRAWAREA_H
